CREATE TYPE Distribution AS TABLE (EventID INT, EventProb FLOAT, CumProb FLOAT) 
GO

CREATE FUNCTION dbo.RN_MULTINOMIAL 
    (@Multinomial Distribution READONLY, @URN FLOAT)
RETURNS INT --Cannot use WITH SCHEMABINDING 
AS
BEGIN
    RETURN 
        ISNULL(
            (   SELECT TOP 1 EventID
                FROM @Multinomial
                WHERE @URN < CumProb
                ORDER BY CumProb)
            -- Handle unlikely case where URN = exactly 1.0
            ,(  SELECT MAX(EventID) 
                FROM @Multinomial))
END
GO

CREATE FUNCTION dbo.RN_NORMAL 
    (@Mean FLOAT, @StDev FLOAT, @URN1 FLOAT, @URN2 FLOAT)
RETURNS FLOAT WITH SCHEMABINDING 
AS
BEGIN
    -- Based on the Box-Muller Transform
    RETURN (@StDev * SQRT(-2 * LOG(@URN1))*COS(2*ACOS(-1.)*@URN2)) + @Mean
END
GO

CREATE FUNCTION dbo.RN_EXPONENTIAL (@Lambda FLOAT, @URN FLOAT)
RETURNS FLOAT WITH SCHEMABINDING 
AS
BEGIN
    RETURN -LOG(@URN)/@Lambda
END
GO

CREATE FUNCTION dbo.RN_WEIBULL (@Alpha FLOAT, @Beta FLOAT, @URN FLOAT)
RETURNS FLOAT WITH SCHEMABINDING 
AS
BEGIN
    RETURN POWER((-1. / @Alpha) * LOG(1. - @URN), 1./@Beta)
END
GO

CREATE FUNCTION dbo.RN_LAPLACE (@u FLOAT, @b FLOAT, @URN FLOAT)
RETURNS FLOAT WITH SCHEMABINDING 
AS
BEGIN
    RETURN @u - @b * LOG(1 - 2 * ABS(@URN - 0.5)) *
        CASE WHEN 0 < @URN - 0.5 THEN 1 WHEN 0 > @URN - 0.5 THEN -1 ELSE 0 END
END
GO